package renderers
{
	import mx.containers.Box;
	import mx.controls.Image;
	import mx.controls.listClasses.BaseListData;
	import mx.controls.listClasses.IDropInListItemRenderer;
    	   
	public class SexRenderer extends Box
		implements IDropInListItemRenderer
	{
        private var image:Image;
        		
        // Embed icons.
        [Embed(source="/assets/smale.png")]
        public var maleSymbol:Class; 
        
        [Embed(source="/assets/sfemale.png")]
        public var femaleSymbol:Class;
        
		public function SexRenderer()
		{
			super();
			setStyle("horizontalAlign", "center");
            image = new Image();
		}
        
		// ----- listData -----
		private var _listData:BaseListData;
		[Bindable("dataChange")]
		public function get listData():BaseListData
		{
			return _listData;
		}

		public function set listData(value:BaseListData):void
		{
			_listData = value;
		}
		// -----   -----
        override protected function createChildren():void
        {
            super.createChildren();
            addChild(image);
        }
       
		// Override the set method for the data property.
    	override public function set data(value:Object):void 
    	{
        	super.data = value;
        	if (value != null) 
        	{
        		var currentValue:int = value.sex;
          		toolTip= resourceManager.getString("myappli", (currentValue == 0 ? "cview.cbsex.female" : "cview.cbsex.male"));
        		switch(currentValue) 
        		{
 					case 0:
 						image.source = femaleSymbol;
 						break;
 					case 1:
 						image.source = maleSymbol;
						break;

  					default:
 						image.source = null;
 				}
 			} 
 		}
	}
}