
class AmazonApplication {

	static function calculateRebate(oldPrice:String, newPrice:String, precision:Number):String {
		var oldPStr:String = AmazonApplication.replace(oldPrice, "$", "");
		var newPStr:String = AmazonApplication.replace(newPrice, "$", "");		
		
		oldPStr = AmazonApplication.trim(oldPStr);
		newPStr = AmazonApplication.trim(newPStr);
		
		var oldP:Number  = Number(oldPStr);
		var newP:Number  = Number(newPStr);
		
		if (oldP == newP) {
			return "";
		}
		
		var percent:Number = (1 - (newP/oldP))*100;
		
		// Source code: class "mx.data.formatters.NumberFormatter"
		var stringval = percent.toString();
		var result;
		if (stringval.indexOf(".") >= 0)
		{
			var items = stringval.split(".");
			if (precision > 0)
			{
				var fraction = items[1] + "000000000000000000000000000000000";
				result = items[0] + "." + fraction.substr(0, precision);
			}
			else
			{
				result = items[0];
			}
		}
		else
		{
			result = stringval;
		}
		
		return "-"+result+"%";
	}
	

	static function trim(str:String):String {
		if (str == undefined) return undefined;
 		for (var i = 0; i < str.length && str.charAt(i) == ' '; i++);
		for (var j = str.length - 1; j >= i && str.charAt(j) == ' '; j--);
		return str.substring(i, ++j);
	}
	
	static function replace(str:String, find:String,replace:String):String {
		return str.split(find).join( replace);
 	}
	
}
